<?php
/*
Plugin Name: contact form hiragana check
Plugin URI: 
Description: Contact form 7での問い合わせで本文にひらがなが含まれていないものを受け付けない。
Version: 1.0
Author: けーちゃん
Author URI:
*/
?>
<?php

add_filter('wpcf7_validate_textarea', 'contact_form_hiragana_check_validate', 10, 2);
add_filter('wpcf7_validate_textarea*', 'contact_form_hiragana_check_validate', 10, 2);

function contact_form_hiragana_check_validate($result, $tag){
    $hiragana_num = 5; // ひらがなが数値以下なら受け付けない
    $check_name = 'your-message'; // 本文タグの名前 

    $tag_name = $tag['name'];
    if($check_name !== $tag_name) return $result;

    $value = (isset($_POST[$tag_name])) ? (string) $_POST[$tag_name] : '';
 
    if ( (int)preg_match_all('/[ぁ-ん]/u', $value) < $hiragana_num ) {
        $result['valid'] = false;
        $result['reason'] = array(
            $tag_name => 'ひらがなを'.$hiragana_num.'文字以上入力してください。'
        );
    }
    return $result;
}
